<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Car Handover Form</title>
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
      <style>
         body {
         background-color: #f5faff;
         }
         .form-section {
         background-color: #ffffff;
         border-radius: 12px;
         padding: 20px;
         box-shadow: 0 0 10px rgba(0,0,0,0.05);
         }
         .form-section + .form-section {
         margin-top: 20px;
         }
         .section-title {
         font-weight: 600;
         font-size: 1.1rem;
         margin-bottom: 10px;
         }
         .btn-outline-primary {
         border-radius: 8px;
         }
         .btn-primary {
         border-radius: 8px;
         }
         .form-control,
         .form-select {
         border-radius: 8px;
         }
         .icon-btn {
         background-color: #e7f1ff;
         border: 1px solid #cfe2ff;
         border-radius: 8px;
         color: #0d6efd;
         font-weight: 500;
         }
         .icon-btn i {
         margin-right: 5px;
         }
         .btn-group-footer {
         margin-top: 30px;
         }
      </style>
   </head>
   <body>
      <div class="container my-5" style="max-width: 900px;">
         <a href="<?php echo e(route('home')); ?>" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
         <h3 class="fw-bold">Car Handover Form</h3>
         <p class="text-muted"> Document vehicle transfers and conditions</p>
         <!-- New Vehicle Handover -->
         <div class="form-section">
            <h5>New Vehicle Handover</h5>
            <p class="form-subtitle">Document vehicle transfer and conditions</p>
            <div class="row g-3">
               <!-- Vehicle Information -->
               <div class="col-md-4">
                  <label class="form-label">Plate Number</label>
                  <input type="text" class="form-control" placeholder="Enter plate number">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Model</label>
                  <input type="text" class="form-control" placeholder="Enter car model">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Type</label>
                  <input type="text" class="form-control" placeholder="Enter vehicle type">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Brand</label>
                  <input type="text" class="form-control" placeholder="Enter vehicle brand">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Mileage</label>
                  <input type="text" class="form-control" placeholder="Enter current mileage">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Location *</label>
                  <input type="text" class="form-control" placeholder="Enter current location">
               </div>
               <!-- Delegated Switch -->
               <div class="col-md-4 form-toggle">
                  <label class="form-label">Delegated</label>
                  <div class="form-check form-switch">
                     <input class="form-check-input" type="checkbox" role="switch" id="delegatedSwitch">
                  </div>
               </div>
               <!-- Reason for No Delegation -->
               <div class="col-md-8" id="reasonField">
                  <label class="form-label">Reason for No Delegation</label>
                  <input type="text" class="form-control" placeholder="Enter reason">
              </div>

               <!-- Delegation Number (Hidden by default) -->
               <div class="col-md-8" id="delegationNumberField" style="display: none;">
                  <label class="form-label">Delegation Number</label>
                  <input type="text" class="form-control" placeholder="Enter Delegation Number">
               </div>
            </div>
         </div>
         <!-- Vehicle Contents -->
         <div class="form-section">
            <h6>Vehicle Contents</h6>
            <div class="row g-3">
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="spareTire">
                     <label class="form-check-label" for="spareTire">Spare Tire</label>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="jackHandle">
                     <label class="form-check-label" for="jackHandle">Jack & Handle</label>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="safetyKit">
                     <label class="form-check-label" for="safetyKit">Safety Kit</label>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="fireExtinguisher">
                     <label class="form-check-label" for="fireExtinguisher">Fire Extinguisher</label>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="dashCam">
                     <label class="form-check-label" for="dashCam">Dash Cam</label>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-check">
                     <input class="form-check-input" type="checkbox" id="other">
                     <label class="form-check-label" for="other">Other</label>
                  </div>
               </div>

               <div class="col-md-8" id="otherContentField" style="display: none;">
                    <label class="form-label">Specify Other Contents</label>
                    <input type="text" class="form-control" placeholder="Please Specify other contents">
                </div>
            </div>
         </div>
         <div class="form-section">
            <!-- Receiver Information -->
            <h6>Receiver Information</h6>
            <div class="row g-3">
               <div class="col-md-4">
                  <label class="form-label">Receiver Name</label>
                  <input type="text" class="form-control" placeholder="Enter receiver's name">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Receiver Phone</label>
                  <input type="text" class="form-control" placeholder="Enter receiver's phone">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Receiver ID</label>
                  <input type="text" class="form-control" placeholder="Enter receiver's ID number">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Supervisor Name</label>
                  <input type="text" class="form-control" placeholder="Enter supervisor's name">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Date</label>
                  <input type="date" class="form-control">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Time</label>
                  <input type="time" class="form-control">
               </div>
            </div>
         </div>
         <!-- Photo Evidence -->
         <div class="form-section">
            <h6>Car Images</h6>
            <div class="row g-3">
               <div class="col-md-12">
                  <p class="text-muted mb-2">Upload photo car Image</p>
                  <!-- Hidden file input -->
                  <input type="file" id="photo-input" accept="image/*" capture="environment" style="display: none;">
                  <!-- Styled button -->
                  <button type="button" class="btn icon-btn" onclick="document.getElementById('photo-input').click();">
                  <i class="bi bi-image"></i> Car  Photo
                  </button>
               </div>
            </div>
         </div>

         
          <!-- Buttons -->
        <div class="d-flex justify-content-end gap-2 btn-group-footer">
          <button class="btn btn-outline-secondary">Cancel</button>
          <button class="btn btn-primary">Submit</button>
        </div>
      </div>
      
      <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function () {
        // Delegated switch toggle
        $(document).ready(function () {
        $('#delegatedSwitch').on('change', function () {
            if ($(this).is(':checked')) {
                $('#delegationNumberField').slideDown();
                $('#reasonField').slideUp(); // hide reason field
            } else {
                $('#delegationNumberField').slideUp();
                $('#reasonField').slideDown(); // show reason field
            }
        });

        // On page load - handle default switch state
        if ($('#delegatedSwitch').is(':checked')) {
            $('#delegationNumberField').show();
            $('#reasonField').hide();
        } else {
            $('#delegationNumberField').hide();
            $('#reasonField').show();
        }
    });

        // Show/hide other content field based on checkbox
        $('#other').on('change', function () {
            if ($(this).is(':checked')) {
                $('#otherContentField').slideDown();
            } else {
                $('#otherContentField').slideUp();
            }
        });
    });
</script>

     
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
   </body>
</html><?php /**PATH C:\xampp\htdocs\security\resources\views/front/car_handovers.blade.php ENDPATH**/ ?>