<!DOCTYPE html>
<html>
<head>
    <title>Incident Report List</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #999; padding: 5px; text-align: left; }
        th { background-color: #eee; }
        img { max-height: 60px; }
    </style>
</head>
<body>
    <h2>All Event Incident Reports</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Photo</th>
                <th>Guard Name</th>
                <th>Shift</th>
                <th>Location</th>
                <th>Date</th>
                <th>Reporting Time</th>
                <th>Report Details</th>
                <th>Action Taken</th>
                <th>Reporting Person</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $incidents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $incident): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key + 1); ?></td>
                    <td>
                        <?php if($incident->photo): ?>
                            <img src="<?php echo e(public_path('incident_photos/' . $incident->photo)); ?>" alt="Photo">
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($incident->guard_name); ?></td>
                    <td><?php echo e($incident->shift); ?></td>
                    <td><?php echo e($incident->location); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($incident->date)->format('d M, Y')); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($incident->reporting_time)->format('h:i A')); ?></td>
                    <td><?php echo e($incident->report_details); ?></td>
                    <td><?php echo e($incident->action_taken); ?></td>
                    <td><?php echo e($incident->reporting_person); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/EventIncident/pdf.blade.php ENDPATH**/ ?>