<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Staff Evaluation Report</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Staff Evaluation Details</h4>
                <a href="<?php echo e(route('monthlyReport.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label class="fw-semibold">Location:</label>
                    <div><?php echo e($report->location); ?></div>
                </div>

                <div class="mb-3">
                    <label class="fw-semibold">Description:</label>
                    <div><?php echo e($report->description ?? '-'); ?></div>
                </div>

                <?php if($report->photo): ?>
                    <div class="mb-3">
                        <label class="fw-semibold">Photo Evidence:</label><br>
                        <img src="<?php echo e(asset('storage/' . $report->photo)); ?>" class="img-thumbnail" style="max-height: 200px; max-width: 200px;">
                    </div>
                <?php endif; ?>

                <?php
                    $staffEntries = $report->staff_entries ?? [];
                ?>

                <?php if(!empty($staffEntries)): ?>
                    <div class="table-responsive mt-4">
                        <h5 class="fw-bold">Staff Entries</h5>
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Staff Name</th>
                                    <th>Shift</th>
                                    <th>Attendance</th>
                                    <th>Duties</th>
                                    <th>Uniform</th>
                                    <th>Presence</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $staffEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($entry['name'] ?? '-'); ?></td>
                                        <td><?php echo e($entry['shift'] ?? '-'); ?></td>
                                        <td><?php echo e($entry['attendance'] ?? '-'); ?></td>
                                        <td><?php echo e($entry['duties'] ?? '-'); ?></td>
                                        <td><?php echo e($entry['uniform'] ?? '-'); ?></td>
                                        <td><?php echo e($entry['presence'] ?? '-'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                <?php else: ?>
                    <p class="text-muted">No staff entries available.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/ManagerMonthlyReport/show.blade.php ENDPATH**/ ?>