<?php echo $__env->make('layouts.frontend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container mt-5 mb-5">
    <?php if($colorbox): ?>
        <h1 class="text-center mt-3 mb-3" style="color: <?php echo e($colorbox->color); ?>;">
            <?php echo e($colorbox->label); ?>

        </h1>
    <?php endif; ?>

    
        <div class="row justify-content-center">
            <div class="col-md-6">
                <canvas id="partCharts"></canvas>
            </div>
        </div>
           
</div>



<?php
$totalParts = count($parts);
$equalValue = $totalParts > 0 ? round(100 / $totalParts, 2) : 0;

$labels = $parts->pluck('name')->toArray();
$values = array_fill(0, $totalParts, $equalValue);
$colors = $parts->pluck('color')->map(fn($color) => $color ?: '#E2EAF2')->toArray(); // Default color if empty
$ids = $parts->pluck('id')->toArray();
?>

<script>
    var piedata = <?php echo json_encode($values, 15, 512) ?>;  
var labels = <?php echo json_encode($labels, 15, 512) ?>; 
var backgroundColors = <?php echo json_encode($colors, 15, 512) ?>; 
var partIds = <?php echo json_encode($ids, 15, 512) ?>; 

const ctx = document.getElementById('partCharts').getContext('2d');
const partCharts = new Chart(ctx, {
    type: 'pie',
    data: {
        labels: labels, 
        datasets: [{
            data: piedata, 
            backgroundColor: backgroundColors, 
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'top',
                labels: {
                    usePointStyle: true,
                    generateLabels: function(chart) {
                        const original = Chart.overrides.pie.plugins.legend.labels.generateLabels;
                        const labels = original(chart);

                        labels.forEach(label => {
                            label.hidden = !chart.isDatasetVisible(0) || chart.getDatasetMeta(0).data[label.index].hidden;
                        });

                        return labels;
                    }
                },
                onClick: function(evt, legendItem, legend) {
                    const index = legendItem.index;
                    const chart = legend.chart;
                    const meta = chart.getDatasetMeta(0);

                    // Toggle the visibility of the dataset
                    meta.data[index].hidden = !meta.data[index].hidden;
                    chart.update();
                }
            },
            tooltip: {
                enabled: false 
            }
        }
    },
    plugins: [{
        id: 'centerLabels',
        afterDraw: function(chart) {
            const ctx = chart.ctx;
            chart.data.datasets.forEach((dataset, i) => {
                const meta = chart.getDatasetMeta(i);
                meta.data.forEach((element, index) => {
                    if (element.hidden) return; // Skip hidden segments

                    const label = chart.data.labels[index];
                    const position = element.tooltipPosition();

                    ctx.fillStyle = '#050505'; 
                    ctx.font = (window.innerWidth < 768) ? 'bold 10px Arial' : 'bold 16px Arial';
                    ctx.textAlign = 'center';
                    ctx.textBaseline = 'middle';
                    
                    ctx.fillText(label, position.x, position.y);
                });
            });
        }
    }]
});

// Handle click event on the pie chart
document.getElementById('partCharts').onclick = function(evt) {
    const activePoints = partCharts.getElementsAtEventForMode(evt, 'nearest', { intersect: true }, true);
    if (activePoints.length) {
        const index = activePoints[0].index;
        const partId = partIds[index];

        window.location.href = `subpart?part_id=${partId}`;
    }
};

</script>


<?php echo $__env->make('layouts.frontend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/u306728840/domains/sntsur.online/public_html/Dashboard/resources/views/sections.blade.php ENDPATH**/ ?>