<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Manager Monthly Report</title>
   <link rel="icon" href="<?php echo e(asset('logos/fiv.png')); ?>" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background-color: #f5faff;
    }

    .form-section {
      background-color: #ffffff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }

    .form-section + .form-section {
      margin-top: 20px;
    }

    .section-title {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 10px;
    }

    .btn-outline-primary {
      border-radius: 8px;
    }

    .btn-primary {
      border-radius: 8px;
    }

    .form-control,
    .form-select {
      border-radius: 8px;
    }

    .icon-btn {
      background-color: #e7f1ff;
      border: 1px solid #cfe2ff;
      border-radius: 8px;
      color: #0d6efd;
      font-weight: 500;
    }

    .icon-btn i {
      margin-right: 5px;
    }

    .btn-group-footer {
      margin-top: 30px;
    }
  </style>
</head>
<body>

<div class="container my-5" >
  <a href="<?php echo e(route('home')); ?>" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
  <h3 class="fw-bold">Report Archive</h3>
  <p class="text-muted">View your submitted reports</p>


  

   <!-- Report Details -->
<div class="form-section">
  <div class="row">
    <div class="col-md-5">
    <input type="date" class="form-control" id="reportDate" />
    </div>
  </div>
 

  <!-- Filter status section (initially hidden) -->
  <div class="d-flex align-items-center justify-content-between mt-3"  style="display: none;">
    <div class="text-muted" id="filterLabel">Filter applied:</div>
    <div class="d-flex gap-2">
      <button class="btn btn-outline-danger btn-sm" id="clearFilter"><i class="bi bi-x-circle"></i> Clear Filter</button>
      <button class="btn btn-outline-primary btn-sm" id="refreshPage"><i class="bi bi-arrow-clockwise"></i> Refresh</button>
    </div>
  </div>
</div>




  


  <!-- Location Details -->
  <div class="form-section" id="filterSection">
    
   
  </div>


  <!-- Buttons -->
  <!--<div class="d-flex justify-content-end gap-2 btn-group-footer">-->
  <!--  <button class="btn btn-outline-secondary">Cancel</button>-->
  <!--  <button class="btn btn-primary">Submit</button>-->
  <!--</div>-->
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$('#reportDate').on('change', function () {
  let selectedDate = $(this).val();
  if (selectedDate) {
    $('#filterLabel').html(`<strong>Filter applied:</strong> ${selectedDate}`);
    $('#filterSection').slideDown();

    $('#backupDownloadLink').remove();
    $('#filterSection').append(`
      <a href="download-backup?date=${selectedDate}" class="btn btn-success btn-sm" id="backupDownloadLink">
        <i class="bi bi-download"></i> Download Backup
      </a>
    `);
  }
});


</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>


</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/front/reports_archive.blade.php ENDPATH**/ ?>