<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                      <a href="<?php echo e(route('dashboard')); ?>">
                       <i class="fa-solid fa-house"></i>
                      </a>
                    </li>
                    <li class="separator">
                     <i class="fa-solid fa-chevron-right"></i>
                    </li>
                <li class="nav-item">
                    <a href="#">User Management </a>
                </li>
            </ul>
        </div>


        <div class="row">
            <div class="col-md-12">
                
                <div class="card">
                     <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">User List</h4>
                       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users-create')): ?> <a href="<?php echo e(route('user.create')); ?>" class="btn btn-primary">+ Add User</a><?php endif; ?>
                    </div>
                      <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <div class="card-body">
                        <div class="table-responsive">
                          <table id="basic-datatables" class="display table table-primary table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Profile Photo</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td> <img src="<?php echo e(asset('public/profile_photos/' . $user->image)); ?>" alt="Profile Photo" width="50" class="rounded-circle"></td>
                                        <td><?php echo e($user->name); ?></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td><?php echo e($user->roles->first()->name ?? 'N/A'); ?></td>
                                        <td>
                                          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users-edit')): ?>  <a href="<?php echo e(route('user.edit', $user->id)); ?>" class="btn btn-warning btn-sm">Edit</a><?php endif; ?>
                                            
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users-delete')): ?> <form action="<?php echo e(route('user.delete', $user->id)); ?>" method="POST" style="display:inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form><?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/u306728840/domains/sntsur.online/public_html/Dashboard/resources/views/user/index.blade.php ENDPATH**/ ?>