<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator"><i class="fa-solid fa-chevron-right"></i></li>
                <li class="nav-item"><a href="#">Incident Details</a></li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Incident Report Details</h4>
                <a href="<?php echo e(route('eventIncident.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>
            <div class="card-body">
                <p><strong>Guard Name:</strong> <?php echo e($incident->guard_name); ?></p>
                <p><strong>Shift:</strong> <?php echo e($incident->shift); ?></p>
                <p><strong>Location:</strong> <?php echo e($incident->location); ?></p>
                <p><strong>Date:</strong> <?php echo e($incident->date); ?></p>
                <p><strong>Reporting Time:</strong> <?php echo e($incident->reporting_time); ?></p>
                <p><strong>Report Details:</strong> <?php echo e($incident->report_details); ?></p>
                <p><strong>Action Taken:</strong> <?php echo e($incident->action_taken); ?></p>
                <p><strong>Reporting Person:</strong> <?php echo e($incident->reporting_person); ?></p>
                
                <?php if($incident->photo): ?>
                    <p><strong>Photo Evidence:</strong></p>
                    <img src="<?php echo e(asset('incident_photos/' . $incident->photo)); ?>" alt="Photo Evidence" style="max-width: 100px;">
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/EventIncident/show.blade.php ENDPATH**/ ?>