<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Manager Monthly Report</title>
   <link rel="icon" href="<?php echo e(asset('logos/fiv.png')); ?>" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background-color: #f5faff;
    }

    .form-section {
      background-color: #ffffff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }

    .form-section + .form-section {
      margin-top: 20px;
    }

    .section-title {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 10px;
    }

    .btn-outline-primary {
      border-radius: 8px;
    }

    .btn-primary {
      border-radius: 8px;
    }

    .form-control,
    .form-select {
      border-radius: 8px;
    }

    .icon-btn {
      background-color: #e7f1ff;
      border: 1px solid #cfe2ff;
      border-radius: 8px;
      color: #0d6efd;
      font-weight: 500;
    }

    .icon-btn i {
      margin-right: 5px;
    }

    .btn-group-footer {
      margin-top: 30px;
    }
  </style>
</head>
<body>

<div class="container my-5" >
  <a href="<?php echo e(route('home')); ?>" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
  <h3 class="fw-bold">Weekly Report</h3>
  <div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
 
<form action="<?php echo e(route('weeklyReport.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

<!-- Staff Assessment -->
<div class="form-section">
  <h5>Staff Assessment</h5>
  <!--<div class="d-flex justify-content-between align-items-center">-->
    <div class="section-title">Staff Entries</div>
  <!--  <button id="add-assessment-btn" class="btn btn-outline-primary btn-sm">-->
  <!--    <i class="bi bi-plus-circle"></i> Add Staff Entry-->
  <!--  </button>-->
  <!--</div>-->
  
  <!--<div id="staff-assessment-container"></div>-->
  
  <div id="staff-data-container"></div>
                    <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-staff-data-btn">
                        <i class="bi bi-plus-circle"></i> Add Staff Assessment
                    </button>
                    <p class="text-muted mt-2">No staff entries added yet. Click the button above to add staff entries.</p>
</div>


  <!-- Staff Evaluation -->
<div class="form-section">
  <h5>Staff Evaluation</h5>
  <!--<div class="d-flex justify-content-between align-items-center">-->
    <div class="section-title">Staff Entries</div>
    <!--<button id="add-evaluation-btn" class="btn btn-outline-primary btn-sm">-->
    <!--  <i class="bi bi-plus-circle"></i> Add Staff Entry-->
    <!--</button>-->
  <!--</div>-->
 
  <!--<div id="staff-evaluation-container"></div>-->
  

                    <div id="staff-entries-container"></div>
                    <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-staff-entry-btn">
                        <i class="bi bi-plus-circle"></i> Add Staff Evaluation
                    </button>
                     <p class="text-muted mt-2">No staff entries added yet. Click the button above to add staff entries.</p>
</div>


  <!-- Report Details -->
  <div class="form-section">
    <div class="section-title">Report Details</div>
    <label for="description" class="form-label">Description</label>
    <textarea class="form-control" id="description" name="description" rows="4" placeholder="Enter additional details"></textarea>
  </div>

  <!-- Photo Evidence -->

<div class="form-section">
  <div class="section-title">Photo Evidence</div>
  <p class="text-muted mb-2">Upload photo evidence of your inspection</p>

  <!-- Hidden file input -->
  <input type="file" id="photo-input" name="photo" accept="image/*" capture="environment" style="display: none;">

  <!-- Styled button -->
  <button type="button" class="btn icon-btn" onclick="document.getElementById('photo-input').click();">
    <i class="bi bi-image"></i> Select Photo
  </button>
</div>


  <!-- Location Details -->
  <div class="form-section">
    <div class="section-title">Location Details</div>
    <label for="location" class="form-label">Location <span class="text-danger">*</span></label>
    <div class="input-group">
      <input type="text" name="location" class="form-control" id="location" placeholder="Enter location" />
      <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
    </div>
  </div>

  <!-- Buttons -->
  <div class="d-flex justify-content-end gap-2 btn-group-footer">
    <button class="btn btn-outline-secondary">Cancel</button>
    <button type="submit" class="btn btn-primary">Submit</button>
  </div>
  </form>
</div>


<!--<script>-->
<!--  let assessmentCount = 0;-->
<!--  let evaluationCount = 0;-->

<!--  document.addEventListener("DOMContentLoaded", function () {-->
    // Containers
<!--    const assessmentSection = document.querySelector('#staff-assessment-container');-->
<!--    const evaluationSection = document.querySelector('#staff-evaluation-container');-->

    // Buttons
<!--    const assessmentBtn = document.querySelector('#add-assessment-btn');-->
<!--    const evaluationBtn = document.querySelector('#add-evaluation-btn');-->

    // Assessment Button Click
<!--    assessmentBtn.addEventListener("click", function () {-->
<!--      assessmentCount++;-->
<!--      const entry = createStaffEntry(`Staff Assessment Entry #${assessmentCount}`);-->
<!--      assessmentSection.appendChild(entry);-->
<!--    });-->

    // Evaluation Button Click
<!--    evaluationBtn.addEventListener("click", function () {-->
<!--      evaluationCount++;-->
<!--      const entry = createStaffEntry(`Staff Evaluation Entry #${evaluationCount}`);-->
<!--      evaluationSection.appendChild(entry);-->
<!--    });-->

<!--    function createStaffEntry(title) {-->
<!--      const entry = document.createElement("div");-->
<!--      entry.classList.add("form-section");-->
<!--      entry.innerHTML = `-->
<!--        <div class="border rounded p-3 position-relative mb-3" style="background:#f8f9fa;">-->
<!--          <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" aria-label="Close" onclick="this.closest('.form-section').remove();"></button>-->
<!--          <h6 class="mb-3">${title}</h6>-->
<!--          <div class="row g-3">-->
<!--            <div class="col-md-6">-->
<!--               <label class="form-label">Staff Name</label>-->
<!--              <input type="text" class="form-control" placeholder="Staff Name">-->
<!--            </div>-->
<!--            <div class="col-md-6">-->
<!--               <label class="form-label">Shift </label>-->
<!--              <input type="text" class="form-control" placeholder="Shift">-->
<!--            </div>-->
<!--            <div class="col-md-6">-->
<!--            <label class="form-label">Attendance </label>-->
<!--            <select class="form-select"><option selected disabled>Select rating</option><option>Excellent</option><option>Good</option><option>Average</option><option>Poor</option></select>-->
             
<!--            </div>-->
<!--            <div class="col-md-6">-->
<!--            <label class="form-label">Duties </label>-->
<!--              <select class="form-select"><option selected disabled>Select rating</option><option>Excellent</option><option>Good</option><option>Average</option><option>Poor</option></select>-->
             
<!--            </div>-->
<!--            <div class="col-md-6">-->
<!--            <label class="form-label">Uniform </label>-->
<!--            <select class="form-select"><option selected disabled>Select rating</option><option>Excellent</option><option>Good</option><option>Average</option><option>Poor</option></select>-->
           
<!--            </div>-->
<!--            <div class="col-md-6">-->
<!--            <label class="form-label">Presence </label>-->
<!--            <select class="form-select"><option selected disabled>Select rating</option><option>Excellent</option><option>Good</option><option>Average</option><option>Poor</option></select>-->
              
<!--            </div>-->
<!--          </div>-->
<!--        </div>-->
<!--      `;-->
<!--      return entry;-->
<!--    }-->
<!--  });-->
<!--</script>-->
<script>
    let staffDataCount = 0;

    document.getElementById("add-staff-data-btn").addEventListener("click", function () {
        staffDataCount++;

        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Assessment #${staffDataCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_data[${staffDataCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_data[${staffDataCount}][shift]" class="form-control">
                </div>
                  <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_data[${staffDataCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_data[${staffDataCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_data[${staffDataCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_data[${staffDataCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-data-container").insertAdjacentHTML("beforeend", entryHTML);
    });

    let staffEvaluationCount = 0;

    document.getElementById("add-staff-entry-btn").addEventListener("click", function () {
        staffEvaluationCount++;

        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Evaluation #${staffEvaluationCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_entries[${staffEvaluationCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_entries[${staffEvaluationCount}][shift]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_entries[${staffEvaluationCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_entries[${staffEvaluationCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_entries[${staffEvaluationCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_entries[${staffEvaluationCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-entries-container").insertAdjacentHTML("beforeend", entryHTML);
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>


</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/front/supervisor_reports.blade.php ENDPATH**/ ?>