<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>GFSP Dashboard</title>
  <link rel="icon" href="<?php echo e(asset('logos/fiv.png')); ?>" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  <style>
    body {
      background-color:#F7FAFC;
    }

    .card {
      border-radius: 15px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
    .navbar .bi {
      font-size: 20px;
      color: darkblue;
    }


    .welcome-text {
      font-size: 2.5rem;
      font-weight: 700;
      background: linear-gradient(to right, #9d00ff, #0d6efd);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }

    .pending {
      color: red;
      font-size: 0.9rem;
    }

    .submit-btn {
      border-radius: 10px;
      padding: 10px;
      font-weight: 500;
    }

    .icon-box {
      font-size: 1.2rem;
      color: #999;
    }

    .section-title {
      color: #6610f2;
      font-weight: 600;
    }

    .progress-bar-custom {
      background: linear-gradient(to right, #7f00ff, #00c6ff);
    }

    .rounded-shadow {
      border-radius: 20px;
      box-shadow: 0 3px 15px rgba(0,0,0,0.08);
    }
  </style>
</head>
<body>


<!-- Navbar -->
<nav class="navbar bg-light shadow-sm px-3 p-3">
  <div class="container-fluid d-flex justify-content-between">
    <div class="d-flex gap-4 align-items-center">
     <a href="<?php echo e(route('manager_report')); ?>"> <i class="bi bi-file-earmark" data-bs-toggle="tooltip" title="Manager Reports"></i></a>
     <a href="<?php echo e(route('supervisor_reports')); ?>"><i class="bi bi-clipboard-check" data-bs-toggle="tooltip" title="Supervisor Reports"></i></a>
     <a href="<?php echo e(route('event_incidents')); ?>"><i class="bi bi-exclamation-triangle" data-bs-toggle="tooltip" title="Event Incidents"></i></a>
     <a href="<?php echo e(route('car_handovers')); ?>"><i class="bi bi-car-front" data-bs-toggle="tooltip" title="Car Handovers"></i></a>
     <a href="<?php echo e(route('reports_archive')); ?>"> <i class="bi bi-archive" data-bs-toggle="tooltip" title="Reports Archive"></i></a>
     <a href="<?php echo e(route('setting')); ?>"> <i class="bi bi-gear" data-bs-toggle="tooltip" title="Settings"></i></a>
    </div>
    <div class="d-flex gap-4 align-items-center">
      <a href="#"> <i class="bi bi-bell" data-bs-toggle="tooltip" title="Notifications"></i></a>
      <div class="dropdown">
          <a href="#" class="d-flex align-items-center text-dark text-decoration-none" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-person-circle fs-4 me-2" data-bs-toggle="tooltip" title="Profile"></i>
            <span><?php echo e(Auth::user()->name); ?></span>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
            <li><a class="dropdown-item" href="<?php echo e(route('setting')); ?>"><i class="bi bi-gear me-2"></i>Setting</a></li>
            <li><hr class="dropdown-divider"></li>
            <li>
              <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right me-2"></i>Logout
              </a>
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
              </form>
            </li>
          </ul>
      </div>
    </div>




    </div>
  </div>
</nav>


<!-- Welcome -->
<div class="container mt-4">
  <div class="d-flex align-items-center gap-3 mt-4 bg-dark">
    <img src="<?php echo e(asset('logos/logo.png')); ?>" alt="GFSP Logo" style="height: 60px;">
    <h1 class="welcome-text mb-0">Welcome to GFSP Security</h1>
  </div>

  <!-- Visit Cards -->
  <div class="row mt-4 g-4">
    <div class="col-md-6">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="card-title mb-0">Monthly Visits <span class="pending">(Pending)</span></h6>
          <i class="bi bi-people icon-box"></i>
        </div>
        <h3>5</h3>
        <p class="text-muted mb-3">Manager project visits this month</p>
        <div class="input-group">
         
          <button class="btn btn-outline-dark submit-btn">Submit Report</button>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="card-title mb-0">Weekly Visits <span class="pending">(Pending)</span></h6>
          <i class="bi bi-clock-history icon-box"></i>
        </div>
        <h3>3</h3>
        <p class="text-muted mb-3">Supervisor site visits this week</p>
        <div class="input-group">
       
          <button class="btn btn-outline-dark submit-btn">Submit Report</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Visits Overview + Monthly Reports -->
  <div class="row mt-4 g-4">
    <!-- Visits Overview -->
    <div class="col-md-6">
      <div class="card p-4 rounded-shadow">
        <h5 class="section-title"><i class="bi bi-eye"></i> Visits Overview</h5>
        <div class="bg-light p-3 rounded mt-3">
          <p class="mb-1 fw-semibold text-purple">Monthly Pending Visits Overview</p>
          <div class="d-flex align-items-center gap-3 mb-2">
            <i class="bi bi-calendar-event-fill text-primary fs-4"></i>
            <h4 class="mb-0 text-primary">8</h4>
          </div>
          <small class="text-muted">Total pending visits this month</small>
          <div class="progress mt-3" style="height: 6px;">
            <div class="progress-bar progress-bar-custom" role="progressbar" style="width: 80%"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Monthly Reports Chart -->
    <div class="col-md-6">
      <div class="card p-4 rounded-shadow">
        <h5 class="section-title"><i class="bi bi-bar-chart-line"></i> Monthly Reports</h5>
        <canvas id="reportsChart" height="200"></canvas>
      </div>
    </div>
  </div>
</div>

<script>
  const ctx = document.getElementById('reportsChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Monthly', 'Weekly', 'Incidents'],
      datasets: [{
        label: 'Reports',
        data: [8, 15, 3],
        backgroundColor: [
          'rgba(124, 66, 255, 0.8)',
          'rgba(54, 162, 235, 0.8)',
          'rgba(199, 121, 255, 0.8)'
        ],
        borderRadius: 10
      }]
    },
    options: {
      plugins: {
        legend: { display: false }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 4 }
        }
      }
    }
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl)
    })
  });
</script>


</body>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</html>
<?php /**PATH C:\xampp\htdocs\security\resources\views/welcome.blade.php ENDPATH**/ ?>