<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Car Handover Details</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Car Handover Details</h4>
                <a href="<?php echo e(route('handover.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>
            <div class="card-body">

                
                <div class="form-section mb-4">
                    <h5> <strong>New Vehicle Handover </strong></h5>
                    <div class="row g-3">
                        <div class="col-md-4"><strong>Plate Number:</strong> <?php echo e($handover->plate_number); ?></div>
                        <div class="col-md-4"><strong>Model:</strong> <?php echo e($handover->model); ?></div>
                        <div class="col-md-4"><strong>Type:</strong> <?php echo e($handover->type); ?></div>
                        <div class="col-md-4"><strong>Brand:</strong> <?php echo e($handover->brand); ?></div>
                        <div class="col-md-4"><strong>Mileage:</strong> <?php echo e($handover->mileage); ?></div>
                        <div class="col-md-4"><strong>Location:</strong> <?php echo e($handover->location); ?></div>
                        <div class="col-md-4"><strong>Delegated:</strong> <?php echo e($handover->delegated ? 'Yes' : 'No'); ?></div>

                        <?php if($handover->delegated): ?>
                            <div class="col-md-4"><strong>Delegation Number:</strong> <?php echo e($handover->delegation_number); ?></div>
                        <?php else: ?>
                            <div class="col-md-4"><strong>Reason for No Delegation:</strong> <?php echo e($handover->reason_no_delegation); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                
                  <div class="form-section mb-4">
                    <h5><strong>Vehicle Contents</strong></h5>
                    <div class="p-2">
                        <?php $__currentLoopData = $handover->vehicleContents ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge bg-info text-dark px-3 py-2 fs-6 me-2 mb-2 d-inline-block">
                                <?php echo e(is_array($content) ? implode(', ', $content) : $content); ?>

                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>



                
                <div class="form-section mb-4">
                    <h5> <strong>Receiver Information </strong></h5>
                    <div class="row g-3">
                        <div class="col-md-4"><strong>Receiver Name:</strong> <?php echo e($handover->receiver_name); ?></div>
                        <div class="col-md-4"><strong>Receiver Phone:</strong> <?php echo e($handover->receiver_phone); ?></div>
                        <div class="col-md-4"><strong>Receiver ID:</strong> <?php echo e($handover->receiver_id); ?></div>
                        <div class="col-md-4"><strong>Supervisor Name:</strong> <?php echo e($handover->supervisor_name); ?></div>
                        <div class="col-md-4"><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($handover->handover_date)->format('d M, Y')); ?></div>
                        <div class="col-md-4"><strong>Time:</strong> <?php echo e(\Carbon\Carbon::parse($handover->handover_time)->format('h:i A')); ?></div>
                    </div>
                </div>

                
                <div class="form-section mb-4">
                    <h6>Car Photo</h6>
                    <?php if($handover->car_image): ?>
                        <img src="<?php echo e(asset('car_images/' . $handover->car_image)); ?>" class="img-fluid rounded" style="max-width: 100px;" alt="Car Image">
                    <?php else: ?>
                        <p class="text-muted">No image uploaded.</p>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/CarHandover/show.blade.php ENDPATH**/ ?>