<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Edit Incident Report</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit Incident Report</h4>
                        <a href="<?php echo e(route('eventIncident.List')); ?>" class="btn btn-primary">Back to List</a>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('eventIncident.update', $incident->id)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="mb-3">
                                <label>Guard Name</label>
                                <input type="text" class="form-control" name="guard_name" value="<?php echo e(old('guard_name', $incident->guard_name)); ?>" placeholder="Enter Guard Name">
                            </div>
                            <div class="mb-3">
                                <label>Shift</label>
                                <input type="text" class="form-control" name="shift" value="<?php echo e(old('shift', $incident->shift)); ?>" placeholder="Enter Shift">
                            </div>

                            <div class="mb-3">
                                <label>Location</label>
                                <input type="text" name="location" class="form-control" value="<?php echo e(old('location', $incident->location)); ?>" placeholder="Enter Location">
                            </div>
                            <div class="mb-3">
                                <label>Date</label>
                                <input type="date" name="date" class="form-control" value="<?php echo e(old('date', $incident->date)); ?>">
                            </div>
                            <div class="mb-3">
                                <label>Reporting Time</label>
                                <input type="time" name="reporting_time" class="form-control" value="<?php echo e(old('reporting_time', $incident->reporting_time)); ?>">
                            </div>

                            <div class="mb-3">
                                <label>Report Details</label>
                                <textarea name="report_details" rows="4" class="form-control"><?php echo e(old('report_details', $incident->report_details)); ?></textarea>
                            </div>

                            <div class="mb-3">
                                <label>Action Taken</label>
                                <textarea name="action_taken" rows="4" class="form-control"><?php echo e(old('action_taken', $incident->action_taken)); ?></textarea>
                            </div>

                            <div class="mb-3">
                                <label>Reporting Person</label>
                                <input type="text" name="reporting_person" class="form-control" value="<?php echo e(old('reporting_person', $incident->reporting_person)); ?>" placeholder="Enter Name">
                            </div>

                            <div class="mb-3">
                                <label for="photo">Photo Evidence</label>
                                <?php if($incident->photo): ?>
                                    <div class="mb-2">
                                        <img src="<?php echo e(asset('incident_photos/' . $incident->photo)); ?>" alt="Current Photo" width="100">
                                    </div>
                                <?php endif; ?>
                                <input type="file" id="photo" name="photo" class="form-control" accept="image/*">
                            </div>

                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/EventIncident/edit.blade.php ENDPATH**/ ?>