<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>GFSP Dashboard</title>
  <link rel="icon" href="<?php echo e(asset('logos/fiv.png')); ?>" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  <style>
    body {
      background-color:#F7FAFC;
    }

    .card {
      border-radius: 15px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
    .navbar .bi {
      font-size: 20px;
      color: darkblue;
    }


    .welcome-text {
      font-size: 2.5rem;
      font-weight: 700;
      background: linear-gradient(to right, #9d00ff, #0d6efd);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }

    .pending {
      color: red;
      font-size: 0.9rem;
    }

    .submit-btn {
      border-radius: 10px;
      padding: 10px;
      font-weight: 500;
    }

    .icon-box {
      font-size: 1.2rem;
      color: #999;
    }

    .section-title {
      color: #6610f2;
      font-weight: 600;
    }

    .progress-bar-custom {
      background: linear-gradient(to right, #7f00ff, #00c6ff);
    }

    .rounded-shadow {
      border-radius: 20px;
      box-shadow: 0 3px 15px rgba(0,0,0,0.08);
    }
    .welcome-text {
    text-align: center;
}

  </style>
</head>
<body>


<!-- Navbar -->
<nav class="navbar bg-light shadow-sm px-3 p-3">
  <div class="container-fluid d-flex justify-content-between">
    <div class="d-flex gap-4 align-items-center">
     <a href="<?php echo e(route('manager_report')); ?>"> <i class="bi bi-file-earmark" data-bs-toggle="tooltip" title="Manager Reports"></i></a>
     <a href="<?php echo e(route('supervisor_reports')); ?>"><i class="bi bi-clipboard-check" data-bs-toggle="tooltip" title="Supervisor Reports"></i></a>
     <a href="<?php echo e(route('event_incidents')); ?>"><i class="bi bi-exclamation-triangle" data-bs-toggle="tooltip" title="Event Incidents"></i></a>
     <a href="<?php echo e(route('car_handovers')); ?>"><i class="bi bi-car-front" data-bs-toggle="tooltip" title="Car Handovers"></i></a>
     <a href="<?php echo e(route('reports_archive')); ?>"> <i class="bi bi-archive" data-bs-toggle="tooltip" title="Reports Archive"></i></a>
     <a href="<?php echo e(route('setting')); ?>"> <i class="bi bi-gear" data-bs-toggle="tooltip" title="Settings"></i></a>
    </div>
    <div class="d-flex gap-4 align-items-center">
        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-outline-primary">Main Dashboard</a>
      <div class="dropdown">
          <a href="#" role="button" id="notificationDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-bell" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Notifications"></i>
          </a>
        
          <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="notificationDropdown">
            <li class="dropdown-header"><i class="bi bi-bell" ></i>  <strong>Notifications</strong> </li>
            <li><hr class="dropdown-divider"></li>
        
            <!-- Dummy Notification 1 -->
            <li>
              <a class="dropdown-item" href="#">
                <strong>New login</strong> from unknown device<br>
                <small class="text-muted">2 minutes ago</small>
              </a>
            </li><hr class="dropdown-divider"></li>
        
            <!-- Dummy Notification 2 -->
            <li>
              <a class="dropdown-item" href="#">
                <strong>Server Alert:</strong> High CPU usage<br>
                <small class="text-muted">10 minutes ago</small>
              </a>
            </li>
          </ul>
        </div>

      
      <div class="dropdown">
          <a href="#" class="d-flex align-items-center text-dark text-decoration-none" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-person-circle fs-4 me-2" data-bs-toggle="tooltip" title="Profile"></i>
            <span><?php echo e(Auth::user()->name ?? ''); ?></span>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
            <li><a class="dropdown-item" href="<?php echo e(route('setting')); ?>"><i class="bi bi-gear me-2"></i>Setting</a></li>
            <li><hr class="dropdown-divider"></li>
           
            <li>
             <?php if(auth()->guard()->check()): ?>
              <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right me-2"></i>Logout
              </a>
            
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
              </form>
                <?php endif; ?>
                <?php if(auth()->guard()->guest()): ?>
                <li><a class="dropdown-item" href="<?php echo e(route('login')); ?>"><i class="bi bi-box-arrow-in-right me-2"></i> login</a></li>
                <?php endif; ?>
            </li>
          </ul>
      </div>
    </div>




    </div>
</nav>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/layouts/frontend/header.blade.php ENDPATH**/ ?>