<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Car Handover</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Car Handover List</h4>
                        <div>
                            <a href="<?php echo e(route('handover.downloadPdf')); ?>" class="btn btn-dark">Download PDF</a> 
                            <a href="<?php echo e(route('handover.create')); ?>" class="btn btn-primary">+ Add Car Handover</a>
                        </div>
                    </div>

                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Car Image</th>
                                        <th>Plate Number</th>
                                        <th>Model</th>
                                        <th>Brand</th>
                                        <th>Mileage</th>
                                        <th>Location</th>
                                        <th>Handover Date</th>
                                        <th>Handover Time</th>
                                        <th>Receiver</th>
                                        <th>Supervisor</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $handovers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $handover): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <?php if($handover->car_image): ?>
                                                    <img src="<?php echo e(asset('car_images/' . $handover->car_image)); ?>" width="50" class="rounded" alt="Car">
                                                <?php else: ?>
                                                    <span class="text-muted">N/A</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($handover->plate_number); ?></td>
                                            <td><?php echo e($handover->model); ?></td>
                                            <td><?php echo e($handover->brand); ?></td>
                                            <td><?php echo e($handover->mileage); ?></td>
                                            <td><?php echo e($handover->location); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($handover->handover_date)->format('d M, Y')); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($handover->handover_time)->format('h:i A')); ?></td>
                                            <td><?php echo e($handover->receiver_name); ?></td>
                                            <td><?php echo e($handover->supervisor_name); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('handover.edit', $handover->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                                
                                                <a href="<?php echo e(route('handover.show', $handover->id)); ?>" class="btn btn-warning btn-sm">Show</a>
                                                <form action="<?php echo e(route('handover.destroy', $handover->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/CarHandover/index.blade.php ENDPATH**/ ?>