<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                      <a href="<?php echo e(route('dashboard')); ?>">
                       <i class="fa-solid fa-house"></i>
                      </a>
                    </li>
                    <li class="separator">
                     <i class="fa-solid fa-chevron-right"></i>
                    </li>
                <li class="nav-item">
                    <a href="#">Incident Report  </a>
                </li>
            </ul>
        </div>


        <div class="row">
            <div class="col-md-12">
                
                <div class="card">
                     <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Incident Report  List</h4>
                       <div>
                           <a href="<?php echo e(route('eventIncident.downloadPdf')); ?>" class="btn btn-dark">Download PDF</a> 
                           
                        <a href="<?php echo e(route('eventIncident.create')); ?>" class="btn btn-primary">+ Add Incident Report </a>
                       </div>
                    </div>
                      <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <div class="card-body">
                        <div class="table-responsive">
                          <table id="basic-datatables" class="display table table-primary table-hover">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Photo</th>
                                <th>Guard Name</th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th>Date</th>
                                <th>Reporting Time</th>
                                <th>Report Details</th>
                                <th>Action Taken</th>
                                <th>Reporting Person</th>
                                <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $incidents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $incident): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                       
                                        <td>
                                            <?php if($incident->photo): ?>
                                                <img src="<?php echo e(asset('incident_photos/' . $incident->photo)); ?>" alt="Photo" width="50" class="rounded-circle">
                                            <?php else: ?>
                                                <span class="text-muted">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($incident->guard_name); ?></td>
                                        <td><?php echo e($incident->shift); ?></td>
                                        <td><?php echo e($incident->location); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($incident->date)->format('d M, Y')); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($incident->reporting_time)->format('h:i A')); ?></td>
                                        <td><?php echo e(Str::limit($incident->report_details, 40) ?? 'N/A'); ?></td>
                                        <td><?php echo e(Str::limit($incident->action_taken, 40) ?? 'N/A'); ?></td>
                                        <td><?php echo e($incident->reporting_person ?? 'N/A'); ?></td>
                                        <td>
                                           <a href="<?php echo e(route('eventIncident.edit', $incident->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="<?php echo e(route('eventIncident.show', $incident->id)); ?>" class="btn btn-warning btn-sm">show</a>
                                            
                                            <form action="<?php echo e(route('eventIncident.destroy', $incident->id)); ?>" method="POST" style="display:inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/EventIncident/index.blade.php ENDPATH**/ ?>