<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Staff Evaluation</li>
            </ul>
        </div>

        <div class="card">
            <div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>

            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Add Staff Evaluation</h4>
                <a href="<?php echo e(route('monthlyReport.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <form action="<?php echo e(route('monthlyReport.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <!-- Dynamic Staff Entry Section -->
                    <div id="staff-entries-container"></div>
                    <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-entry-btn">
                        <i class="bi bi-plus-circle"></i> Add Staff Entry
                    </button>

                    <!-- Report Details -->
                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Report Details</label>
                        <textarea class="form-control" name="description" rows="4" placeholder="Enter additional details"></textarea>
                    </div>

                    <!-- Photo Evidence -->
                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Photo Evidence</label>
                        <input type="file" name="photo" accept="image/*" class="form-control">
                    </div>

                    <!-- Location -->
                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Location <span class="text-danger">*</span></label>
                        <input type="text" name="location" class="form-control" required placeholder="Enter location">
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-end mt-3">
                       
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    let staffEntryCount = 0;

    document.getElementById("add-entry-btn").addEventListener("click", function () {
        staffEntryCount++;

        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Entry #${staffEntryCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][shift]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_entries[${staffEntryCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_entries[${staffEntryCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_entries[${staffEntryCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_entries[${staffEntryCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-entries-container").insertAdjacentHTML("beforeend", entryHTML);
    });
</script>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/ManagerMonthlyReport/create.blade.php ENDPATH**/ ?>