@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                  <li class="nav-home">
                  <a href="{{route('dashboard')}}">
                   <i class="fa-solid fa-house"></i>
                  </a>
                </li>
                <li class="separator">
                 <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Edit User</a>
                </li>
            </ul>
        </div>

         <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit User</h4>
                         <a href="{{ route('user.list') }}" class="btn btn-primary">Back to List</a>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('user.update', $user->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label>Name</label>
                                <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                            </div>

                            <div class="mb-3">
                                <label>Email</label>
                                <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                            </div>

                            <div class="mb-3">
                                <label>Password (Leave blank to keep current)</label>
                                <input type="password" name="password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label>Role</label>
                                <select name="role" class="form-control">
                                    @foreach($roles as $id => $name)
                                        <option value="{{ $id }}" {{ $user->roles->first()->id == $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="image" class="form-label">Profile Photo</label>
                                <input type="file" class="form-control" id="image" name="image" accept="image/*" onchange="previewImage(event)">
                                
                                <!-- Show existing image -->
                                @if ($user->image)
                                    <img id="imagePreview" src="{{ asset('public/profile_photos/' . $user->image) }}" alt="Profile Image" class="mt-3 rounded" style="width: 150px; height: 150px; object-fit: cover;">
                                @else
                                    <img id="imagePreview" src="#" alt="Profile Preview" class="mt-3 rounded" style="display: none; width: 150px; height: 150px; object-fit: cover;">
                                @endif
                            </div>


                            <button type="submit" class="btn btn-primary">Update User</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function previewImage(event) {
        var input = event.target;
        var reader = new FileReader();
        reader.onload = function () {
            var img = document.getElementById("imagePreview");
            img.src = reader.result;
            img.style.display = "block";
        };
        reader.readAsDataURL(input.files[0]);
    }
</script>

@include('layouts.backend.footer')
