<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900">
            {{ __('Profile Photo') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600">
            {{ __("Update your account's profile photo.") }}
        </p>
    </header>

    <!-- Show Current Profile Photo -->
    <div class="mb-3">
        @if(auth()->user()->image)
            <img src="{{ asset('public/profile_photos/' . auth()->user()->image) }}" alt="Profile Photo" width="100" class="rounded-circle">
        @else
            <p>No Profile Photo</p>
        @endif
    </div>

    <!-- Profile Photo Upload Form -->
    <form method="post" action="{{ route('profile.update.photo') }}" enctype="multipart/form-data" class="mt-6 space-y-6">
        @csrf
        @method('patch')

        <div>
            <x-input-label for="image" :value="__('Profile Photo')" />
            <input id="image" name="image" type="file" class="mt-1 block w-full" required />
            <x-input-error class="mt-2" :messages="$errors->get('image')" />
        </div>

        <div class="flex items-center gap-4">
            <x-primary-button>{{ __('Update Photo') }}</x-primary-button>

            @if (session('status') === 'photo-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600"
                >{{ __('Profile photo updated.') }}</p>
            @endif
        </div>
    </form>
</section>
