<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Manager Monthly Report</title>
   <link rel="icon" href="{{asset('logos/fiv.png')}}" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background-color: #f5faff;
    }

    .form-section {
      background-color: #ffffff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }

    .form-section + .form-section {
      margin-top: 20px;
    }

    .section-title {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 10px;
    }

    .btn-outline-primary {
      border-radius: 8px;
    }

    .btn-primary {
      border-radius: 8px;
    }

    .form-control,
    .form-select {
      border-radius: 8px;
    }

    .icon-btn {
      background-color: #e7f1ff;
      border: 1px solid #cfe2ff;
      border-radius: 8px;
      color: #0d6efd;
      font-weight: 500;
    }

    .icon-btn i {
      margin-right: 5px;
    }

    .btn-group-footer {
      margin-top: 30px;
    }
  </style>
</head>
<body>

<div class="container my-5" >
  <a href="{{route('home')}}" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
  <h3 class="fw-bold">Manager Monthly Report</h3>
  <p class="text-muted">Monthly staff assessment report</p>
  <div>
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
<form action="{{ route('monthlyReport.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
  <!-- Staff Evaluation -->
  <div class="form-section">
       
    <div class=" ">
      <div class="section-title">Staff Evaluation</div>
      
      <!-- Dynamic Staff Entry Section -->
        <div id="staff-entries-container"></div>
        <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-entry-btn">
            <i class="bi bi-plus-circle"></i> Add Staff Entry
        </button>
    </div>
    <p class="text-muted mt-2" id="no-entry-msg">No staff entries added yet. Click the button above to add staff entries.</p>
  </div>

  <!-- Report Details -->
  <div class="form-section">
    <div class="section-title">Report Details</div>
    <label for="description" class="form-label">Description</label>
    <textarea class="form-control" name="description" id="description" rows="4" placeholder="Enter additional details"></textarea>
  </div>

  <!-- Photo Evidence -->

<div class="form-section">
  <div class="section-title">Photo Evidence</div>
  <p class="text-muted mb-2">Upload photo evidence of your inspection</p>

  <!-- Hidden file input -->
  <input type="file"  name="photo" id="photo-input" accept="image/*" capture="environment" style="display: none;">

  <!-- Styled button -->
  <button type="button" class="btn icon-btn" onclick="document.getElementById('photo-input').click();">
    <i class="bi bi-image"></i> Select Photo
  </button>
</div>


  <!-- Location Details -->
  <div class="form-section">
    <div class="section-title">Location Details</div>
    <label for="location" class="form-label">Location <span class="text-danger">*</span></label>
    <div class="input-group">
      <input type="text" class="form-control" name="location" id="location" placeholder="Enter location" />
      <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
    </div>
  </div>

  <!-- Buttons -->
  <div class="d-flex justify-content-end gap-2 btn-group-footer">
    <button class="btn btn-outline-secondary">Cancel</button>
    <button type="submit" class="btn btn-primary">Submit</button>
  </div>
</div>
</form>




<script>
    let staffEntryCount = 0;

    document.getElementById("add-entry-btn").addEventListener("click", function () {
        
        // Hide the "no entry" message
        const noEntryMsg = document.getElementById("no-entry-msg");
        if (noEntryMsg) {
            noEntryMsg.style.display = "none";
        }
        
        
        staffEntryCount++;

        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Entry #${staffEntryCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][shift]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_entries[${staffEntryCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_entries[${staffEntryCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_entries[${staffEntryCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_entries[${staffEntryCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-entries-container").insertAdjacentHTML("beforeend", entryHTML);
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>


</html>
