<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Manager Monthly Report</title>
   <link rel="icon" href="{{asset('logos/fiv.png')}}" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background-color: #f5faff;
    }

    .form-section {
      background-color: #ffffff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }

    .form-section + .form-section {
      margin-top: 20px;
    }

    .section-title {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 10px;
    }

    .btn-outline-primary {
      border-radius: 8px;
    }

    .btn-primary {
      border-radius: 8px;
    }

    .form-control,
    .form-select {
      border-radius: 8px;
    }

    .icon-btn {
      background-color: #e7f1ff;
      border: 1px solid #cfe2ff;
      border-radius: 8px;
      color: #0d6efd;
      font-weight: 500;
    }

    .icon-btn i {
      margin-right: 5px;
    }

    .btn-group-footer {
      margin-top: 30px;
    }
  </style>
</head>
<body>

<div class="container my-5" >
  <a href="{{route('home')}}" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
  <h3 class="fw-bold">Incident Report</h3>
  <p class="text-muted"> Document security incidents</p>

  <!-- Staff Evaluation -->
 <form method="POST" action="{{ route('eventIncident.store') }}" enctype="multipart/form-data">
  @csrf

  <div class="form-section">
      <div>
         @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
      </div>
    <div class="d-flex justify-content-between align-items-center">
      <div class="section-title">Guard Information</div>
    </div>
    
    <div class="row"> 
    <div class="col-md-6 mb-3">
        <label for="name" class="form-label">Guard Name</label>
        <input type="text" class="form-control" name="guard_name" id="name" placeholder="Enter Guard Name">
      
      </div>
      <div class="col-md-6 mb-3">
        <label for="Shift" class="form-label">Shift</label>
        <input type="text" class="form-control" name="shift" id="Shift"  placeholder="Enter Shift information ">
      </div>
    </div>

  </div>

   <!-- Incident Details -->
   <div class="form-section">
    <div class="d-flex justify-content-between align-items-center">
      <div class="section-title">Incident Details</div>
    </div>
    
    <div class="row"> 
      <div class="col-md-6 mb-3">
        <label for="name" class="form-label">Location *</label>
        <input type="text" name="location" class="form-control" id="name" placeholder="Enter Guard Name">
      </div>
      <div class="col-md-6 mb-3">
        <label for="Shift" class="form-label">Date</label>
        <input type="date" name="date" class="form-control" id="Shift"  >
      </div>
      <div class="col-md-6 mb-3">
        <label for="Shift" class="form-label">Reporting Timeate</label>
        <input type="time" name="reporting_time" class="form-control" name="time[]">
      </div>
    </div>
  </div>
  

  <!-- Report Details -->
  <div class="form-section">
    <div class="section-title">Report Details</div>
    
    <textarea class="form-control" name="report_details" id="description" rows="4" placeholder="Enter additional details"></textarea>
  </div>
 

   <!--  Action Taken  -->
   <div class="form-section">
    <div class="section-title"> Action Taken</div>
    
    <textarea class="form-control" name="action_taken" id="description" rows="4" placeholder=" Describe  Action Taken"></textarea>
  </div>

   <!-- Reporting Person -->
   <div class="form-section">
    <div class="section-title">Reporting Person</div>
    <div class="input-group">
      <input type="text" class="form-control" name="reporting_person" id="location" placeholder="Enter location" />
     
    </div>
  </div>
  
  <!-- Photo Evidence -->
  <div class="form-section">
    <div class="section-title">Photo Evidence</div>
    <p class="text-muted mb-2">Upload photo evidence of your inspection</p>

    <!-- Hidden file input -->
    <input type="file" id="photo-input" name="photo" accept="image/*" capture="environment" style="display: none;">

    <!-- Styled button -->
    <button type="button" class="btn icon-btn" onclick="document.getElementById('photo-input').click();">
      <i class="bi bi-image"></i> Select Photo
    </button>
  </div>


 

  <!-- Buttons -->
  <div class="d-flex justify-content-end gap-2 btn-group-footer">
    <button class="btn btn-outline-secondary">Cancel</button>
    <button class="btn btn-primary">Submit</button>
  </div>
</form>

</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>


</html>
