<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Car Handover Form</title>
       <link rel="icon" href="{{asset('logos/fiv.png')}}" type="image/x-icon"/>
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
      <style>
         body {
         background-color: #f5faff;
         }
         .form-section {
         background-color: #ffffff;
         border-radius: 12px;
         padding: 20px;
         box-shadow: 0 0 10px rgba(0,0,0,0.05);
         }
         .form-section + .form-section {
         margin-top: 20px;
         }
         .section-title {
         font-weight: 600;
         font-size: 1.1rem;
         margin-bottom: 10px;
         }
         .btn-outline-primary {
         border-radius: 8px;
         }
         .btn-primary {
         border-radius: 8px;
         }
         .form-control,
         .form-select {
         border-radius: 8px;
         }
         .icon-btn {
         background-color: #e7f1ff;
         border: 1px solid #cfe2ff;
         border-radius: 8px;
         color: #0d6efd;
         font-weight: 500;
         }
         .icon-btn i {
         margin-right: 5px;
         }
         .btn-group-footer {
         margin-top: 30px;
         }
      </style>
   </head>
   <body>
      <div class="container my-5" >
         <a href="{{route('home')}}" class="text-decoration-none text-dark mb-3 d-inline-block"><i class="bi bi-arrow-left"></i></a>
         <h3 class="fw-bold">Car Handover Form</h3>
         <p class="text-muted"> Document vehicle transfers and conditions</p>
         <div>
             @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
          </div>
         <form action="{{ route('handover.store') }}" method="POST" enctype="multipart/form-data">
         @csrf
         <!-- New Vehicle Handover -->
         <div class="form-section">
            <h5>New Vehicle Handover</h5>
            <p class="form-subtitle">Document vehicle transfer and conditions</p>
            <div class="row g-3">
                
               <!-- Vehicle Information -->
               <div class="col-md-4">
                  <label class="form-label">Plate Number</label>
                  <input type="text" class="form-control" name="plate_number" placeholder="Enter plate number">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Model</label>
                  <input type="text" class="form-control" name="model" placeholder="Enter car model">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Type</label>
                  <input type="text" class="form-control" name="type" placeholder="Enter vehicle type">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Brand</label>
                  <input type="text" class="form-control" name="brand" placeholder="Enter vehicle brand">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Mileage</label>
                  <input type="text" class="form-control" name="mileage" placeholder="Enter current mileage">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Location *</label>
                  <input type="text" class="form-control" name="location" placeholder="Enter current location">
               </div>
                <div class="col-md-4">
                            <label class="form-label">Delegated</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="delegated" value="0"> <!-- Default off -->
                                <input class="form-check-input" type="checkbox" id="delegatedSwitch" name="delegated" value="1">
                            </div>
                        </div>
                        
                      <div class="col-md-8">
                            <div class="form-group" id="delegation_number_field" style="display: none;">
                                <label>Delegation Number</label>
                                <input type="text" name="delegation_number" class="form-control">
                            </div>
                            
                             <div class="form-group" id="reason_no_delegation_field" style="display: none;">
                            <label>Reason for No Delegation</label>
                            <input type="text" name="reason_no_delegation" class="form-control">
                        </div>
                      </div>
            </div>
         </div>
         <!-- Vehicle Contents -->
         <div class="form-section">
            <h6>Vehicle Contents</h6>
            <div class="row g-3">
                            @php
                                $contents = ['spareTire' => 'Spare Tire', 'jackHandle' => 'Jack & Handle', 'safetyKit' => 'Safety Kit', 'fireExtinguisher' => 'Fire Extinguisher', 'dashCam' => 'Dash Cam', 'other' => 'Other'];
                            @endphp
                            @foreach($contents as $id => $label)
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="{{ $id }}" name="contents[]"
                                           value="{{ $label }}">
                                    <label class="form-check-label" for="{{ $id }}">{{ $label }}</label>
                                </div>
                            </div>
                            @endforeach

                            <div class="col-md-8" id="otherContentField" style="display: none;">
                                <label class="form-label">Specify Other Contents</label>
                                <input type="text" class="form-control" name="other_contents" placeholder="Please specify">
                            </div>
                        </div>
         </div>
         <div class="form-section">
            <!-- Receiver Information -->
            <h6>Receiver Information</h6>
            <div class="row g-3">
               <div class="col-md-4">
                  <label class="form-label">Receiver Name</label>
                  <input type="text" name="receiver_name" class="form-control" placeholder="Enter receiver's name">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Receiver Phone</label>
                  <input type="text"  name="receiver_phone" class="form-control" placeholder="Enter receiver's phone">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Receiver ID</label>
                  <input type="text" name="receiver_id" class="form-control" placeholder="Enter receiver's ID number">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Supervisor Name</label>
                  <input type="text" name="supervisor_name" class="form-control" placeholder="Enter supervisor's name">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Date</label>
                  <input type="date" name="handover_date" class="form-control">
               </div>
               <div class="col-md-4">
                  <label class="form-label">Time</label>
                  <input type="time" name="handover_time" class="form-control">
               </div>
            </div>
         </div>
         <!-- Photo Evidence -->
         <div class="form-section">
            <h6>Car Images</h6>
            <div class="row g-3">
               <div class="col-md-12">
                  <p class="text-muted mb-2">Upload photo car Image</p>
                  <!-- Hidden file input -->
                  <input type="file" name="car_image" id="photo-input" accept="image/*" capture="environment" style="display: none;">
                  <!-- Styled button -->
                  <button type="button" class="btn icon-btn" onclick="document.getElementById('photo-input').click();">
                  <i class="bi bi-image"></i> Car  Photo
                  </button>
               </div>
            </div>
         </div>

         
          <!-- Buttons -->
        <div class="d-flex justify-content-end gap-2 btn-group-footer">
          <button class="btn btn-outline-secondary">Cancel</button>
          <button class="btn btn-primary">Submit</button>
        </div>
        </form>
      </div>
      
      <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

 
<script>
   
    document.addEventListener('DOMContentLoaded', function () {
        
        const otherContentCheckbox = document.getElementById('other');
        const otherContentField = document.getElementById('otherContentField');

       

        if (otherContentCheckbox) {
            otherContentCheckbox.addEventListener('change', function () {
                otherContentField.style.display = this.checked ? 'block' : 'none';
            });
        }
    });

</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const delegatedSwitch = document.getElementById("delegatedSwitch");
        const delegationField = document.getElementById("delegation_number_field");
        const reasonField = document.getElementById("reason_no_delegation_field");

        function toggleDelegationFields() {
            if (delegatedSwitch.checked) {
                delegationField.style.display = "block";
                reasonField.style.display = "none";
            } else {
                delegationField.style.display = "none";
                reasonField.style.display = "block";
            }
        }

        delegatedSwitch.addEventListener("change", toggleDelegationFields);

        // Call it once on page load
        toggleDelegationFields();
    });
</script>


     
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
   </body>
</html>