<!DOCTYPE html>
<html>
<head>
    <title>Monthly Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        h2 { margin-bottom: 10px; }
        h4, h5 { margin: 8px 0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
        th { background-color: #f2f2f2; }
        img { max-width: 60px; max-height: 60px; }
    </style>
</head>
<body>
    <h2>Monthly Report</h2>

    @foreach($monthlyReports as $index => $report)
        <h4>{{ $index + 1 }}. Report Entry</h4>
        <table>
            <tr>
                <th style="width: 5%;">#</th>
                <td>{{ $index + 1 }}</td>
            </tr>
            <tr>
                <th>Photo</th>
                <td>
                    @if($report->photo && file_exists(public_path('storage/' . $report->photo)))
                        <img src="{{ public_path('storage/' . $report->photo) }}" alt="Photo">
                    @else
                        No Photo
                    @endif
                </td>
            </tr>
            <tr>
                <th>Location</th>
                <td>{{ $report->location }}</td>
            </tr>
            <tr>
                <th>Description</th>
                <td>{{ $report->description }}</td>
            </tr>
            <tr>
                <th>Date & Time</th>
                <td>{{ \Carbon\Carbon::parse($report->created_at)->format('d M Y, h:i A') }}</td>
            </tr>
        </table>

        {{-- 1.1 Staff Evaluation --}}
        <h5>{{ $index + 1 }}.1 Staff Evaluation</h5>
        <table>
            <thead>
                <tr>
                    <th>Staff Name</th>
                    <th>Behavior</th>
                    <th>Alertness</th>
                    <th>Response</th>
                    <th>Reporting</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $staffEvaluations = is_string($report->staff_entries) ? json_decode($report->staff_entries, true) : $report->staff_entries;
                @endphp
                @if(is_array($staffEvaluations))
                    @foreach ($staffEvaluations as $eval)
                        <tr>
                            <td>{{ $eval['name'] ?? '-' }}</td>
                            <td>{{ $eval['shift'] ?? '-' }}</td>
                            <td>{{ $eval['attendance'] ?? '-' }}</td>
                            <td>{{ $eval['duties'] ?? '-' }}</td>
                            <td>{{ $eval['uniform'] ?? '-' }}</td>
                            <td>{{ $eval['presence'] ?? '-' }}</td>
                        </tr>
                    @endforeach
                @else
                    <tr><td colspan="6">No Staff Evaluation Data</td></tr>
                @endif
            </tbody>
        </table>
        <hr>
    @endforeach
</body>
</html>
