@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Edit Incident Report</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit Incident Report</h4>
                        <a href="{{ route('eventIncident.List') }}" class="btn btn-primary">Back to List</a>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('eventIncident.update', $incident->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label>Guard Name</label>
                                <input type="text" class="form-control" name="guard_name" value="{{ old('guard_name', $incident->guard_name) }}" placeholder="Enter Guard Name">
                            </div>
                            <div class="mb-3">
                                <label>Shift</label>
                                <input type="text" class="form-control" name="shift" value="{{ old('shift', $incident->shift) }}" placeholder="Enter Shift">
                            </div>

                            <div class="mb-3">
                                <label>Location</label>
                                <input type="text" name="location" class="form-control" value="{{ old('location', $incident->location) }}" placeholder="Enter Location">
                            </div>
                            <div class="mb-3">
                                <label>Date</label>
                                <input type="date" name="date" class="form-control" value="{{ old('date', $incident->date) }}">
                            </div>
                            <div class="mb-3">
                                <label>Reporting Time</label>
                                <input type="time" name="reporting_time" class="form-control" value="{{ old('reporting_time', $incident->reporting_time) }}">
                            </div>

                            <div class="mb-3">
                                <label>Report Details</label>
                                <textarea name="report_details" rows="4" class="form-control">{{ old('report_details', $incident->report_details) }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label>Action Taken</label>
                                <textarea name="action_taken" rows="4" class="form-control">{{ old('action_taken', $incident->action_taken) }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label>Reporting Person</label>
                                <input type="text" name="reporting_person" class="form-control" value="{{ old('reporting_person', $incident->reporting_person) }}" placeholder="Enter Name">
                            </div>

                            <div class="mb-3">
                                <label for="photo">Photo Evidence</label>
                                @if($incident->photo)
                                    <div class="mb-2">
                                        <img src="{{ asset('incident_photos/' . $incident->photo) }}" alt="Current Photo" width="100">
                                    </div>
                                @endif
                                <input type="file" id="photo" name="photo" class="form-control" accept="image/*">
                            </div>

                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
