@include('layouts.backend.header')
<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Create Incident Report</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div>
                         @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                      </div>
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Create Incident Report</h4>
                        <a href="{{ route('eventIncident.List') }}" class="btn btn-primary">Back to List</a>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('eventIncident.store') }}" enctype="multipart/form-data">
                            @csrf

                            {{-- Guard Information --}}
                            <div class="mb-3">
                                <label>Guard Name</label>
                                <input type="text" class="form-control" name="guard_name" placeholder="Enter Guard Name">
                            </div>
                            <div class="mb-3">
                                <label>Shift</label>
                                <input type="text" class="form-control" name="shift" placeholder="Enter Shift">
                            </div>

                            {{-- Incident Details --}}
                            <div class="mb-3">
                                <label>Location</label>
                                <input type="text" name="location" class="form-control" placeholder="Enter Location">
                            </div>
                            <div class="mb-3">
                                <label>Date</label>
                                <input type="date" name="date" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label>Reporting Time</label>
                                <input type="time" name="reporting_time" class="form-control">
                            </div>

                            {{-- Report Details --}}
                            <div class="mb-3">
                                <label>Report Details</label>
                                <textarea name="report_details" rows="4" class="form-control" placeholder="Enter Report Details"></textarea>
                            </div>

                            {{-- Action Taken --}}
                            <div class="mb-3">
                                <label>Action Taken</label>
                                <textarea name="action_taken" rows="4" class="form-control" placeholder="Describe Action Taken"></textarea>
                            </div>

                            {{-- Reporting Person --}}
                            <div class="mb-3">
                                <label>Reporting Person</label>
                                <input type="text" name="reporting_person" class="form-control" placeholder="Enter Name">
                            </div>

                            {{-- Photo Evidence --}}
                            <div class="mb-3">
                                <label for="photo">Photo Evidence</label>
                                <input type="file" id="photo" name="photo" class="form-control" accept="image/*">
                            </div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                            
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@include('layouts.backend.footer')
