@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Car Handover Details</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Car Handover Details</h4>
                <a href="{{ route('handover.List') }}" class="btn btn-primary">Back to List</a>
            </div>
            <div class="card-body">

                {{-- Vehicle Info --}}
                <div class="form-section mb-4">
                    <h5> <strong>New Vehicle Handover </strong></h5>
                    <div class="row g-3">
                        <div class="col-md-4"><strong>Plate Number:</strong> {{ $handover->plate_number }}</div>
                        <div class="col-md-4"><strong>Model:</strong> {{ $handover->model }}</div>
                        <div class="col-md-4"><strong>Type:</strong> {{ $handover->type }}</div>
                        <div class="col-md-4"><strong>Brand:</strong> {{ $handover->brand }}</div>
                        <div class="col-md-4"><strong>Mileage:</strong> {{ $handover->mileage }}</div>
                        <div class="col-md-4"><strong>Location:</strong> {{ $handover->location }}</div>
                        <div class="col-md-4"><strong>Delegated:</strong> {{ $handover->delegated ? 'Yes' : 'No' }}</div>

                        @if ($handover->delegated)
                            <div class="col-md-4"><strong>Delegation Number:</strong> {{ $handover->delegation_number }}</div>
                        @else
                            <div class="col-md-4"><strong>Reason for No Delegation:</strong> {{ $handover->reason_no_delegation }}</div>
                        @endif
                    </div>
                </div>

                {{-- Vehicle Contents --}}
                  <div class="form-section mb-4">
                    <h5><strong>Vehicle Contents</strong></h5>
                    <div class="p-2">
                        @foreach($handover->vehicleContents ?? [] as $content)
                            <span class="badge bg-info text-dark px-3 py-2 fs-6 me-2 mb-2 d-inline-block">
                                {{ is_array($content) ? implode(', ', $content) : $content }}
                            </span>
                        @endforeach
                    </div>
                </div>



                {{-- Receiver Info --}}
                <div class="form-section mb-4">
                    <h5> <strong>Receiver Information </strong></h5>
                    <div class="row g-3">
                        <div class="col-md-4"><strong>Receiver Name:</strong> {{ $handover->receiver_name }}</div>
                        <div class="col-md-4"><strong>Receiver Phone:</strong> {{ $handover->receiver_phone }}</div>
                        <div class="col-md-4"><strong>Receiver ID:</strong> {{ $handover->receiver_id }}</div>
                        <div class="col-md-4"><strong>Supervisor Name:</strong> {{ $handover->supervisor_name }}</div>
                        <div class="col-md-4"><strong>Date:</strong> {{ \Carbon\Carbon::parse($handover->handover_date)->format('d M, Y') }}</div>
                        <div class="col-md-4"><strong>Time:</strong> {{ \Carbon\Carbon::parse($handover->handover_time)->format('h:i A') }}</div>
                    </div>
                </div>

                {{-- Car Photo --}}
                <div class="form-section mb-4">
                    <h6>Car Photo</h6>
                    @if ($handover->car_image)
                        <img src="{{ asset('car_images/' . $handover->car_image) }}" class="img-fluid rounded" style="max-width: 100px;" alt="Car Image">
                    @else
                        <p class="text-muted">No image uploaded.</p>
                    @endif
                </div>

            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
