@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Car Handover</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Car Handover List</h4>
                        <div>
                            <a href="{{ route('handover.downloadPdf') }}" class="btn btn-dark">Download PDF</a> 
                            <a href="{{ route('handover.create') }}" class="btn btn-primary">+ Add Car Handover</a>
                        </div>
                    </div>

                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Car Image</th>
                                        <th>Plate Number</th>
                                        <th>Model</th>
                                        <th>Brand</th>
                                        <th>Mileage</th>
                                        <th>Location</th>
                                        <th>Handover Date</th>
                                        <th>Handover Time</th>
                                        <th>Receiver</th>
                                        <th>Supervisor</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($handovers as $key => $handover)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>
                                                @if($handover->car_image)
                                                    <img src="{{ asset('car_images/' . $handover->car_image) }}" width="50" class="rounded" alt="Car">
                                                @else
                                                    <span class="text-muted">N/A</span>
                                                @endif
                                            </td>
                                            <td>{{ $handover->plate_number }}</td>
                                            <td>{{ $handover->model }}</td>
                                            <td>{{ $handover->brand }}</td>
                                            <td>{{ $handover->mileage }}</td>
                                            <td>{{ $handover->location }}</td>
                                            <td>{{ \Carbon\Carbon::parse($handover->handover_date)->format('d M, Y') }}</td>
                                            <td>{{ \Carbon\Carbon::parse($handover->handover_time)->format('h:i A') }}</td>
                                            <td>{{ $handover->receiver_name }}</td>
                                            <td>{{ $handover->supervisor_name }}</td>
                                            <td>
                                                <a href="{{ route('handover.edit', $handover->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                                
                                                <a href="{{ route('handover.show', $handover->id) }}" class="btn btn-warning btn-sm">Show</a>
                                                <form action="{{ route('handover.destroy', $handover->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
