@include('layouts.backend.header')



<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Car Handover</li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Edit Car Handover</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Edit Car Handover</h4>
                <a href="{{ route('handover.List') }}" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('handover.update', $handover->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- New Vehicle Handover --}}
                    <div class="form-section mb-4">
                        <h5>New Vehicle Handover</h5>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">Plate Number</label>
                                <input type="text" name="plate_number" class="form-control" value="{{ old('plate_number', $handover->plate_number) }}" placeholder="Enter plate number">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Model</label>
                                <input type="text" name="model" class="form-control" value="{{ old('model', $handover->model) }}" placeholder="Enter car model">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Type</label>
                                <input type="text" name="type" class="form-control" value="{{ old('type', $handover->type) }}" placeholder="Enter vehicle type">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Brand</label>
                                <input type="text" name="brand" class="form-control" value="{{ old('brand', $handover->brand) }}" placeholder="Enter vehicle brand">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Mileage</label>
                                <input type="text" name="mileage" class="form-control" value="{{ old('mileage', $handover->mileage) }}" placeholder="Enter current mileage">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Location *</label>
                                <input type="text" name="location" class="form-control" value="{{ old('location', $handover->location) }}" placeholder="Enter current location">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Delegated</label>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="delegated" value="0"> <!-- Default off -->
                                    <input class="form-check-input" type="checkbox" id="delegatedSwitch" name="delegated" value="1" {{ $handover->delegated ? 'checked' : '' }}>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group" id="delegation_number_field" style="{{ $handover->delegated ? 'display: block;' : 'display: none;' }}">
                                    <label>Delegation Number</label>
                                    <input type="text" name="delegation_number" class="form-control" value="{{ old('delegation_number', $handover->delegation_number) }}">
                                </div>
                                
                                <div class="form-group" id="reason_no_delegation_field" style="{{ !$handover->delegated ? 'display: block;' : 'display: none;' }}">
                                    <label>Reason for No Delegation</label>
                                    <input type="text" name="reason_no_delegation" class="form-control" value="{{ old('reason_no_delegation', $handover->reason_for_no_delegation) }}">
                                </div>
                            </div>

                        </div>
                    </div>

                    {{-- Vehicle Contents --}}
                    <div class="form-section mb-4">
                        <h6>Vehicle Contents</h6>
                        <div class="row g-3">
                              @php
                                $selectedContents = [];
                                $otherContent = '';
                            
                                foreach ($handover->vehicleContents as $item) {
                                    if (is_array($item) && isset($item['other'])) {
                                        $selectedContents[] = 'Other';
                                        $otherContent = $item['other'];
                                    } else {
                                        $selectedContents[] = $item;
                                    }
                                }
                            
                                $contents = ['spareTire' => 'Spare Tire', 'jackHandle' => 'Jack & Handle', 'safetyKit' => 'Safety Kit', 'fireExtinguisher' => 'Fire Extinguisher', 'dashCam' => 'Dash Cam', 'other' => 'Other'];
                            @endphp

                          @foreach($contents as $id => $label)
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input"
                                           type="checkbox"
                                           id="{{ $id }}"
                                           name="contents[]"
                                           value="{{ $label }}"
                                           {{ in_array($label, $selectedContents) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="{{ $id }}">{{ $label }}</label>
                                </div>
                            </div>
                        @endforeach


                          <div class="col-md-8" id="otherContentField" style="{{ in_array('Other', $selectedContents) ? '' : 'display: none;' }}">
                                <label class="form-label">Specify Other Contents</label>
                                <input type="text" class="form-control" name="other_contents" placeholder="Please specify"
                                       value="{{ old('other_contents', $otherContent) }}">
                            </div>

                        </div>
                    </div>

                    {{-- Receiver Info --}}
                    <div class="form-section mb-4">
                        <h6>Receiver Information</h6>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">Receiver Name</label>
                                <input type="text" name="receiver_name" class="form-control" value="{{ old('receiver_name', $handover->receiver_name) }}" placeholder="Enter receiver's name">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Receiver Phone</label>
                                <input type="text" name="receiver_phone" class="form-control" value="{{ old('receiver_phone', $handover->receiver_phone) }}" placeholder="Enter receiver's phone">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Receiver ID</label>
                                <input type="text" name="receiver_id" class="form-control" value="{{ old('receiver_id', $handover->receiver_id) }}" placeholder="Enter receiver's ID number">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Supervisor Name</label>
                                <input type="text" name="supervisor_name" class="form-control" value="{{ old('supervisor_name', $handover->supervisor_name) }}" placeholder="Enter supervisor's name">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Date</label>
                                <input type="date" name="handover_date" class="form-control" value="{{ old('handover_date', $handover->handover_date) }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Time</label>
                                <input type="time" name="handover_time" class="form-control" value="{{ old('handover_time', $handover->handover_time) }}">
                            </div>
                        </div>
                    </div>

                    {{-- Car Photo --}}
                    <div class="form-section mb-4">
                        <h6>Car Images</h6>
                        <p class="text-muted mb-2">Upload car photo</p>
                        <input type="file" name="car_image" id="photo-input" accept="image/*" capture="environment" style="display: none;">
                        <button type="button" class="btn btn-outline-primary" onclick="document.getElementById('photo-input').click();">
                            <i class="bi bi-image"></i> Car Photo
                        </button>
                    </div>

                    {{-- Buttons --}}
                    <div class="d-flex justify-content-end gap-2">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
   
  document.addEventListener('DOMContentLoaded', function () {
    const otherCheckbox = document.querySelector('#other');
    const otherField = document.querySelector('#otherContentField');

    function toggleOtherField() {
        if (otherCheckbox.checked) {
            otherField.style.display = '';
        } else {
            otherField.style.display = 'none';
        }
    }

    otherCheckbox.addEventListener('change', toggleOtherField);
    toggleOtherField(); // initial load
});


</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const delegatedSwitch = document.getElementById("delegatedSwitch");
        const delegationField = document.getElementById("delegation_number_field");
        const reasonField = document.getElementById("reason_no_delegation_field");
        
        // Toggle delegation fields
        delegatedSwitch.addEventListener('change', function () {
            if (this.checked) {
                delegationField.style.display = "block";
                reasonField.style.display = "none";
            } else {
                delegationField.style.display = "none";
                reasonField.style.display = "block";
            }
        });
        
        // Initialize state
        if (!delegatedSwitch.checked) {
            delegationField.style.display = "none";
            reasonField.style.display = "block";
        }
    });
</script>



@include('layouts.backend.header')
