<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('car_handovers', function (Blueprint $table) {
            $table->id();
            // Vehicle Information
        $table->string('plate_number')->nullable();
        $table->string('model')->nullable();
        $table->string('type')->nullable();
        $table->string('brand')->nullable();
        $table->string('mileage')->nullable();
        $table->string('location')->nullable();
        $table->boolean('delegated')->default(false);
        $table->string('reason_for_no_delegation')->nullable();
        $table->string('delegation_number')->nullable();

        // Vehicle Contents
         $table->json('vehicleContents')->nullable(); 

        // Receiver Info
        $table->string('receiver_name')->nullable();
        $table->string('receiver_phone')->nullable();
        $table->string('receiver_id')->nullable();
        $table->string('supervisor_name')->nullable();
        $table->date('handover_date')->nullable();
        $table->time('handover_time')->nullable();

        // Photo (file path)
        $table->string('car_image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('car_handovers');
    }
};
