<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_incidents', function (Blueprint $table) {
            $table->id();
             $table->string('guard_name');
            $table->string('shift')->nullable();
            $table->string('location');
            $table->date('date')->nullable();
            $table->time('reporting_time')->nullable();
            $table->text('report_details')->nullable();
            $table->text('action_taken')->nullable();
            $table->string('reporting_person')->nullable();
            $table->string('photo')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_incidents');
    }
};
