<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Logout;
use App\Listeners\UpdateUserStatus;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        Login::class => [
            [UpdateUserStatus::class, 'handleLogin'], // Call handleLogin method
        ],
        Logout::class => [
            [UpdateUserStatus::class, 'handleLogout'], // Call handleLogout method
        ],
    ];

    public function boot()
    {
        parent::boot();
    }
}
