<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CarHandover extends Model
{
    use HasFactory;

    protected $fillable = [
        'plate_number',
        'model',
        'type',
        'brand',
        'mileage',
        'location',
        'delegated',
        'reason_for_no_delegation',
        'delegation_number',
        'spare_tire',
        'jack_handle',
        'safety_kit',
        'fire_extinguisher',
        'dash_cam',
        'other',
        'other_content',
        'receiver_name',
        'receiver_phone',
        'receiver_id',
        'supervisor_name',
        'handover_date',
        'handover_time',
        'car_image',
        'vehicleContents',
        
    ];
    
    protected $casts = 
    [
        "vehicleContents"=> 'array',
    ];
}

