<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SupervisorWeeklyReport;

use Barryvdh\DomPDF\Facade\Pdf;

class SupervisorWeeklyReportController extends Controller
{
  
     public function index()
    {
        $weeklyReports = SupervisorWeeklyReport::latest()->get();
        return view('SupervisorWeeklyReport.index',compact('weeklyReports'));
    }
    
    
     public function create()
    {
        return view('SupervisorWeeklyReport.create'); // your form page
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'description' => 'nullable|string',
            'location' => 'required|string|max:255',
            'staff_data' => 'nullable|array',
            'staff_entries' => 'nullable|array',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
    
        $photoPath = null;
    
        // Check if photo file is uploaded
        if ($request->hasFile('photo')) {
            $photoPath = $request->file('photo')->store('manager_reports', 'public');
        }
    
        $report = SupervisorWeeklyReport::create([
            'description' => $request->input('description'),
            'location' => $request->input('location'),
            'staff_data' => $request->input('staff_data'),
            'staff_entries' => $request->input('staff_entries'), // automatically cast to JSON
            'photo' => $photoPath,
        ]);
    
        return redirect()->back()->with('success', ' Report created successfully!');
    }
    
        public function edit($id)
    {
        $report = SupervisorWeeklyReport::findOrFail($id);
        return view('SupervisorWeeklyReport.edit', compact('report'));
    }
    
    public function update(Request $request, $id)
    {
        $request->validate([
            'description' => 'nullable|string',
            'location' => 'required|string|max:255',
            'staff_data' => 'nullable|array',
            'staff_entries' => 'nullable|array',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
    
        $report = SupervisorWeeklyReport::findOrFail($id);
    
        if ($request->hasFile('photo')) {
            $photoPath = $request->file('photo')->store('manager_reports', 'public');
            $report->photo = $photoPath;
        }
    
        $report->description = $request->input('description');
        $report->location = $request->input('location');
        $report->staff_data = $request->input('staff_data');
        $report->staff_entries = $request->input('staff_entries');
         
        $report->save();
    
        return redirect()->route('weeklyReport.List')->with('success', 'Report updated successfully!');
    }
    
        public function show($id)
    {
        $report = SupervisorWeeklyReport::findOrFail($id);
        return view('SupervisorWeeklyReport.show', compact('report'));
    }
    
    public function destroy($id)
        {
            SupervisorWeeklyReport::destroy($id);
            return back()->with('success', 'Report deleted successfully!.');
        }
        
    public function downloadPdf()
    {
        $weeklyReports = SupervisorWeeklyReport::all();
        $pdf = Pdf::loadView('SupervisorWeeklyReport.pdf', compact('weeklyReports'));
        return $pdf->download('SupervisorWeeklyReport_list.pdf');
    }


}

