<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;


class HomeController extends Controller
{
    public function managerReport()
    {
        return view('front.manager_report');
    }
    
    public function supervisorReport()
    {
        return view('front.supervisor_reports');
    }

    public function eventIncident()
    {
        return view('front.event_incidents');
    }
    public function carHandover()
    {
        return view('front.car_handovers');
    }
   


  // For showing the setting page
public function setting()
{
    return view('front.setting', [
        'user' => auth()->user()
    ]);
}

// For updating profile details
public function update(Request $request)
{
    $user = auth()->user();

    $request->validate([
        'name' => 'required|string|max:255',
        'email' => 'required|email|unique:users,email,' . $user->id,
        'mobile' => 'nullable|string|max:15',
        'image' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
    ]);

    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $imageName = time() . '.' . $image->getClientOriginalExtension();
        $image->move(public_path('profile_photos'), $imageName);
        $user->image = $imageName;
    }

    $user->name = $request->name;
    $user->email = $request->email;
    $user->mobile = $request->mobile;
    $user->save();

    return back()->with('status', 'profile-updated');
}

// For updating password
public function updatePassword(Request $request)
{
    $request->validate([
        'new_password' => 'required|string|min:8|confirmed',
    ]);

    $user = auth()->user();
    $user->password = bcrypt($request->new_password);
    $user->save();

    return back()->with('password_status', 'password-updated');
}


}
  