<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\EventIncident;
  use Barryvdh\DomPDF\Facade\Pdf;

class EventIncidentController extends Controller
{
    public function index()
    {
        $incidents = EventIncident::latest()->get();
        return view('EventIncident.index', compact('incidents'));
    }

    public function create()
    {
        return view('EventIncident.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'guard_name' => 'required|string|max:255',
            'shift' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            'date' => 'required|date',
            'reporting_time' => 'required',
            'report_details' => 'nullable|string',
            'action_taken' => 'nullable|string',
            'reporting_person' => 'nullable|string',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg',
        ]);

        if ($request->hasFile('photo')) {
        $imageName = time() . '.' . $request->photo->extension();
        $request->photo->move(public_path('incident_photos'), $imageName);
        } else {
            $imageName = null;
        }

        EventIncident::create([
            'guard_name' => $request->guard_name,
            'shift' => $request->shift,
            'location' => $request->location,
            'date' => $request->date,
            'reporting_time' => $request->reporting_time,
            'report_details' => $request->report_details,
            'action_taken' => $request->action_taken,
            'reporting_person' => $request->reporting_person,
            'photo' => $imageName,
        ]);

        return redirect()->back()->with('success', 'Incident reported successfully.');
    }

    public function edit($id)
    {
        $incident = EventIncident::findOrFail($id);
        return view('EventIncident.edit', compact('incident'));
    }

    public function update(Request $request, $id)
    {
        $incident = EventIncident::findOrFail($id);

        $request->validate([
            'guard_name' => 'required|string|max:255',
            'shift' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            'date' => 'required|date',
            'reporting_time' => 'required',
            'report_details' => 'nullable|string',
            'action_taken' => 'nullable|string',
            'reporting_person' => 'nullable|string',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg',
        ]);

        if ($request->hasFile('photo')) {
        $imageName = time() . '.' . $request->photo->extension();
        $request->photo->move(public_path('incident_photos'), $imageName);
        } else {
            $imageName = null;
        }

        $incident->update([
            'guard_name' => $request->guard_name,
            'shift' => $request->shift,
            'location' => $request->location,
            'date' => $request->date,
            'reporting_time' => $request->reporting_time,
            'report_details' => $request->report_details,
            'action_taken' => $request->action_taken,
            'reporting_person' => $request->reporting_person,
            'photo' => $imageName,
        ]);

        return redirect()->route('eventIncident.List')->with('success', 'Incident updated successfully.');
    }
    
    public function show($id)
{
    $incident = EventIncident::findOrFail($id);
    return view('EventIncident.show', compact('incident'));
}


        public function destroy($id)
    {
        $incident = EventIncident::findOrFail($id);
        $incident->delete();
    
        return redirect()->back()->with('success', 'Incident deleted successfully.');
    }
    
    
  

  public function downloadPdf()
{
    $incidents = EventIncident::all();
    $pdf = Pdf::loadView('EventIncident.pdf', compact('incidents'));
    return $pdf->download('event_incident_report_list.pdf');
}



}
