<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\classes\UserManager;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\EventIncident;

use Illuminate\Support\Facades\Response;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;



    class EventIncidentController extends Controller
    {
        
    public function eventIncidentStore(Request $request)
    {
        $request->validate([
            'guard_name' => 'required|string|max:255',
            'shift' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            'date' => 'required|date',
            'reporting_time' => 'required',
            'report_details' => 'required|string',
            'action_taken' => 'required|string',
            'reporting_person' => 'required|string',
            'photo' => 'required|image|mimes:jpeg,png,jpg',
        ]);
    
        if ($request->hasFile('photo')) {
            $imageName = time() . '.' . $request->photo->extension();
            $request->photo->move(public_path('incident_photos'), $imageName);
        } else {
            $imageName = null;
        }
    
        $incident = EventIncident::create([
            'guard_name' => $request->guard_name,
            'shift' => $request->shift,
            'location' => $request->location,
            'date' => $request->date,
            'reporting_time' => $request->reporting_time,
            'report_details' => $request->report_details,
            'action_taken' => $request->action_taken,
            'reporting_person' => $request->reporting_person,
            'photo' => $imageName,
        ]);
    
        return response()->json([
            'success' => true,
            'message' => 'Incident reported successfully.',
            'data' => $incident
        ], 200);
    }
    
    
   


public function downloadPdfApi(Request $request)
{
    $incidents = EventIncident::all();

    $pdf = Pdf::loadView('EventIncident.pdf', compact('incidents'));

    // Define the filename and path
    $fileName = 'event_incident_report_list.pdf';
    $filePath = public_path('pdf/' . $fileName);

    // Create the folder if it doesn't exist
    if (!file_exists(public_path('pdf'))) {
        mkdir(public_path('pdf'), 0755, true);
    }

    // Save the PDF to the public/pdf directory
    file_put_contents($filePath, $pdf->output());

    // Return JSON with the public URL
    return response()->json([
        'success' => true,
        'message' => 'PDF generated successfully.',
        'url' => asset('pdf/' . $fileName)
    ], 200);
}

    
}
